#include <time.h>
#include "../common/debug.h"
#include "../common/colors.h"
#include "../common/buffer.h"
#include "../render/ray_common.h"
#include "../render/tracer.h"
#include "../shader/post_shaders.h"
#include "../common/misc.h"
#include <stdlib.h>

#include <pthread.h>

extern scene_data* main_scene;
extern int intersects_calced;

extern pthread_mutex_t mutexor;

void frameless_render(int min, int max)
{
	int i, x, y;
	intersect_data *id;
	color c;
	printd(1, "entering render loop\n");

	for(i=0; i<2000; i++)
	{
		x = (double)rand()/RAND_MAX * main_scene->width;
		y = (double)rand()/RAND_MAX * (max-min) + min;

		id = (intersect_data*)get_idata(x,y);
//pthread_mutex_lock (&mutexor);
		calc_ray(x,y);
//pthread_mutex_unlock (&mutexor);
pthread_mutex_lock (&mutexor);
		id->obj->shader(id, &c);
pthread_mutex_unlock (&mutexor);
		set_color(x, y, &c);
		clear_color(&c);

	}


	intersects_calced = 0;
}
